/********************************************************************
*   A9139M0_RFLIB.h
*   Function & Marco Definitions
*
********************************************************************/
#include "define.h"
#ifndef _A9139M0_RFLIB_H_
#define _A9139M0_RFLIB_H_

/*********************************************************************
**  Global Variable Declaration
*********************************************************************/


/********************************************************************
** function declaration
********************************************************************/
typedef struct
{
    unsigned int offset;
    unsigned int load[7];
} ConfigS;

extern const ConfigS A9139M0_Config[];

/*--------------------------------------------------------------------------*/
/* CONSTANT DECLARATION                                                     */
/*--------------------------------------------------------------------------*/
// CONFIG INDEX
#define INDEX_RSTCTL            0
#define INDEX_MODEC1            1
#define INDEX_MODEC2            2
#define INDEX_STATUS            3
#define INDEX_INTIE             4
#define INDEX_ID1               5
#define INDEX_ID2               6
#define INDEX_FIFO              7
#define INDEX_SYCK              8
#define INDEX_GPIO              9
#define INDEX_CAL              10
#define INDEX_IFC              11
#define INDEX_VCOCC            12
#define INDEX_VCOBC            13
#define INDEX_PLL1             14
#define INDEX_PLL2             15
#define INDEX_PLL3             16
#define INDEX_PLL4             17
#define INDEX_PLL5             18
#define INDEX_PLL6             19
#define INDEX_PLL7             20
#define INDEX_TXCTL            21
#define INDEX_TXPWR            22
#define INDEX_TXMOD            23
#define INDEX_RXCTL            24
#define INDEX_RXG              25
#define INDEX_RXDEM1           26
#define INDEX_RXDEM2           27
#define INDEX_RXDEM3           28
#define INDEX_SYN              29
#define INDEX_DSSS1            30
#define INDEX_DSSS2            31
#define INDEX_CDET             32
#define INDEX_CODE1            33
#define INDEX_CODE2            34
#define INDEX_DELAY            35
#define INDEX_CLOCK1           36
#define INDEX_CLOCK2           37
#define INDEX_RFT              38
#define INDEX_WORT1            39
#define INDEX_WORT2            40
#define INDEX_ADC              41
#define INDEX_RTH              42
#define INDEX_TXPKT            43
#define INDEX_RXPKT            44
#define INDEX_BDT              45
#define INDEX_FPCTL            46
#define INDEX_PWRCTL1          47
#define INDEX_PWRCTL2          48
#define INDEX_PWRCTL3          49
#define INDEX_DCDC_Ctrl1       50
#define INDEX_DCDC_Ctrl2       51
#define INDEX_DCDC_Ctrl3       52
#define INDEX_PMUCON           53
#define INDEX_DCDC_Ctrl4       54
#define INDEX_IO_Ctrl0	       55
#define INDEX_IO_Ctrl1	       56
#define INDEX_IO_Ctrl2	       57
#define INDEX_IO_Ctrl3	       58
#define INDEX_IO_Ctrl4	       59
#define INDEX_RCCTL1           60
#define INDEX_RCCTL2           61
#define INDEX_RCTGM            62
#define INDEX_RFBR             63
#define INDEX_12BADC_CTL       64
#define INDEX_IO_12BADC	       65
#define INDEX_IO_TMRINV	       66
#define INDEX_IO_TMRCTL	       67

/********************************************************************
** RFLIB_Reset
** Description:		RF chip reset
** Parameters:		
** Return value: 	none
** Note: 
*********************************************************************/
void           	RFLIB_Reset ( unsigned char cmd );

/********************************************************************
** RFLIB_InitRF
** Description:		initial RF chip
** Parameters:		none
** Return value: 	0: pass; !=0: Fail
**       			b0: Fail, FBCF=1
**       			b1: Fail, VCCF=1
**       			b2: Fail, VBF0=1
**       			b3: Fail, VBF1=1
**       			b4: Fail, VBF2=1
**       			b5: Fail, Cal Time Out
** Note: 
*********************************************************************/
unsigned char  	RFLIB_InitRF ( void );

/********************************************************************
** RFLIB_StrobeCmd
** Description:		RF Strobe Command
** Parameters:		
** Return value: 	none
** Note: 
*********************************************************************/
void           	RFLIB_StrobeCmd(unsigned char cmd);

/********************************************************************
** RFLIB_WriteID
** Description:		set ID bytes
** Parameters:		ID value(4 bytes)
** Return value: 	none
** Note: 
*********************************************************************/
void			RFLIB_WriteID ( unsigned int id );

/********************************************************************
** RFLIB_ReadID
** Description:		get ID bytes
** Parameters:		none
** Return value: 	ID value(4 bytes)
** Note: 
*********************************************************************/
unsigned int	RFLIB_ReadID ( void );

/********************************************************************
** RFLIB_InitCrystalCL
** Description:		set Internal Crystal Load & Crystal CL
** Parameters:		INTXC[0], XCL[4:0]
** Return value: 	none
** Note: 
*********************************************************************/
void RFLIB_InitCrystalCL ( Uint32 INTXC, Uint32 VCOSC );

/********************************************************************
** RFLIB_SetCH
** Description:		set RF channel
** Parameters:		value=0~47
** Return value: 	none
** Note: 
*********************************************************************/
void RFLIB_SetCH ( Uint32 ch );

#endif
